 ; Ŀ
 ;   Ploot - plot and record.  Largely obsolete, saved as a prototype.     
 ;   Copyright 1997, 1999 by Rocket Software Ltd.                          
 ;   You can't abbreviate anagrams.  Or vice versa.                        
 ; 

 ; Ŀ
 ;   Getcfg - read the configuration file into a list.                     
 ;   Takes one argument, the config file name.                             
 ;   Removes comments and leading and trailing spaces.                     
 ;   Returns the configuration list.                                       
 ; 
 (DEFUN GETCFG (fn / str len stop cfglst)
 ; Ŀ
 ;   Open the data file and make the configuration list.                   
 ; 
  (if (setq fn (open fn "r"))
      (progn
           (while (and (null stop) (setq str (read-line fn)))
                  (while (= (substr str 1 1) " ")
                         (setq str (substr str 2)))
                  (if (and (/= (substr str 1 1) ";")
                           (/= str ""))
                      (progn
                           (setq str (car (splat ";" str)))
                           (while (= (substr str (setq len (strlen str))) " ")
                                  (setq str (substr str 1 (1- len))))
                           (if (= (strcase str t) "notes:")
                               (setq stop t)
                               (setq cfglst (cons str cfglst))))))
           (close fn)))
 (reverse cfglst))
 ; Ŀ
 ;   Getcfg end.                                                           
 ; 

 ; Ŀ
 ;   Jogb - get the job number for the current drawing.                    
 ;                                                                         
 ;   Reads the project number from the external file JobNo.txt which is    
 ;   located in the directory containing the drawing file.                 
 ;   Returns a string or nil.                                              
 ; 
 (DEFUN JOGB (/ fnam joblst jobnam)
 ; Ŀ
 ;   See if the Jobno.txt data file is available; read it into a list.     
 ; 
  (setq fnam (strcat (getvar "dwgprefix") "jobno.txt"))
  (if (and (setq fnam (findfile fnam))
           (setq joblst (getcfg fnam)))
      (setq jobnam (car joblst)))
 jobnam)
 ; Ŀ
 ;   Jogb end.                                                             
 ; 

 ; Ŀ
 ;   Flamak - make a new data file, write the current plot data to it.     
 ; 
 (DEFUN FLAMAK (datstr pfnam / fn)
  (setq fn (open pfnam "w"))
  (write-line (strcat datstr ",1") fn)
  (close fn))
 ; Ŀ
 ;   Flamak end.                                                           
 ; 

 ; Ŀ
 ;   Addat - add data to an existing file.                                 
 ; 
 (DEFUN ADDAT (datstr pfnam / fn str strlst len found)
  (setq len (strlen datstr))
 ; Ŀ
 ;   Read the file contents into a list.                                   
 ; 
  (setq fn (open pfnam "r"))
  (while (setq str (read-line fn))
         (setq strlst (append strlst (list str))))
  (close fn)
 ; Ŀ
 ;   Now try to find the appropriate line.                                 
 ; 
  (setq fo (open pfnam "w"))
  (while (setq str (car strlst))
         (setq strlst (cdr strlst))
         (if (= (substr str 1 len) datstr)
             (progn
                  (setq found t)
                  (setq num (read (substr str (+ len 2))))
                  (setq num (1+ num))
                  (setq str (strcat datstr "," (itoa num)))))
         (write-line str fo))
 ; Ŀ
 ;   If the correct line wasn't found (found = ()) then write it.          
 ; 
  (if (null found) (write-line (strcat datstr ",1") fo))
 (close fo))
 ; Ŀ
 ;   Addat end.                                                            
 ; 

 ; Ŀ
 ;   Cdat - returns the current date.                                      
 ; 
 (DEFUN CDAT (/ dd)
  (setq dd (rtos (fix (getvar "cdate"))))
 (strcat (substr dd 3 2) "." (substr dd 5 2) "." (substr dd 7 2)))
 ; Ŀ
 ;   Cdat end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen linn))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Plaq - create or append to the plot data file.                        
 ;   Calls Splat, Cdat, and either Addat or Flamak                         
 ;   Called by C:Ploote.                                                   
 ;   Takes no arguments, returns nothing.                                  
 ;                                                                         
 ; 
 (DEFUN PLAQ (/ dirf plotid datstr pfnam dirlst)
 ; Ŀ
 ;   Get the required information from the jobno.txt file, if it isn't     
 ;   present use the drawing path.                                         
 ; 
  (if (setq projno (jogb))
      (setq lognam projno)
      (progn
           (setq dirf (getvar "dwgprefix"))
           (setq dirlst (splat "\\" dirf))
           (setq lognam (cadr dirlst))
           (setq 2nd (if (< 2 (length dirlst))
                         (strcat "\\" (nth 2 dirlst)) ""))
           (setq projno (strcat (nth 1 dirlst) 2nd))))
 ; Ŀ
 ;   Get plotter ID string from sysvar.                                    
 ; 
  (setq plotid (getvar "plotid"))
 ; Ŀ
 ;   Make the data string - directory, date, plot ID.                      
 ; 
  (setq datstr (strcat projno "," (cdat) "," plotid))
 ; Ŀ
 ;   File name for the data file to make or update.                        
 ; 
  (setq pfnam (strcat "I:\\plot_log\\" lognam ".plg"))
 ; Ŀ
 ;   See if the file exists, if so then add the data, if not then          
 ;   make it and write the data line.                                      
 ; 
  (if (findfile pfnam)
      (addat datstr pfnam)
      (flamak datstr pfnam))
 (princ))
 ; Ŀ
 ;   Plaq.                                                                 
 ; 

 ; Ŀ
 ;   Ploot.                                                                
 ; 
 (DEFUN C:PLOOT ()
  (command ".plot")
  (command "l")
  (command "0")
  (plaq)
 (princ))